/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.activity.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the
 * content on which an event took place
 */
@ToString
@EqualsAndHashCode
public class ContentDto
{
	private String id;
	private String title;
	private String description;
	private String type;
	private String imageUrl;
	private String url;


	/**
	 * The id should contain a unique identifier for this piece of content.
	 * @return
	 */
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * The title of the piece of content. This will be used in the activities
	 * widgets when describing an activity. An example using the title in the
	 * activities widget is:
	 * Bob Dylan has shared [Relaxing in the Sun].
	 * In this case the [] represents the title of the photo.
	 * @return
	 */
	public String getTitle() { return title; }
	public void setTitle( String title ) { this.title = title; }

	/**
	 * The description of the piece of content. This may be used in the activities
	 * widget to render tool tips for the content's title.
	 * @return
	 */
	public String getDescription() { return description; }
	public void setDescription( String description ) { this.description = description; }

	/**
	 * The type of the piece of content. For example:
	 * image, blog, article, product, pdf...
	 * @return
	 */
	public String getType() { return type; }
	public void setType( String type ) { this.type = type; }

	/**
	 * The URL of an image which is associated to this piece of content.
	 * For example: if the content is an image, this could contain the link
	 * to the image; if the content is a blog post, this could contain the
	 * link to the featured image if one exists; if the content was a product,
	 * this could contain the link to an image of the product.
	 * @return
	 */
	public String getImageUrl() { return imageUrl; }
	public void setImageUrl( String imageUrl ) { this.imageUrl = imageUrl; }

	/**
	 * The URL which when clicked will take us to this piece of content.
	 * For example: the URL to view an image, the URL of a blog post,
	 * the URL of a product page in an e-commerce store, etc.
	 * The URL is used in the activity stream to link the activity item
	 * back to the content on which the behaviour was performed.
	 * @return
	 */
	public String getUrl() { return url; }
	public void setUrl( String url ) { this.url = url; }
}
