/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.activity.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.data.RequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the Activity API in
 * order to reject the specified activity.
 */
@ToString
@EqualsAndHashCode
public class RejectActivityRequestData implements RequestData
{
	protected transient List<String> initializedFields = new ArrayList<>();
	private String reason;


	/**
	 * The reason why the activity was rejected. This is used to give the user
	 * insight as to why the activity was rejected.
	 */
	public String getReason() { return reason; }
	public void setReason( String reason ) {
		initializedFields.add( "reason" );
		this.reason = reason;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}