/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.http.authenticator;

import static io.mambo.sdk.utils.Preconditions.checkArgument;
import static io.mambo.sdk.utils.StringUtils.isNotEmpty;

import java.util.Base64;

/**
 * Default implementation of the {@link MamboCredentials} interface
 */
public class DefaultMamboCredentials implements MamboCredentials
{
	private final String publicKey;
	private final String privateKey;


	public DefaultMamboCredentials( String publicKey, String privateKey ) {
		checkArgument( isNotEmpty( publicKey ), "publicKey must not be null or empty" );
		checkArgument( isNotEmpty( privateKey ), "privateKey must not be null or empty" );
		this.publicKey = publicKey;
		this.privateKey = privateKey;
	}


	@Override
	public String encodedCredentials()
	{
		byte[] credentialBytes = ( publicKey + ":" + privateKey ).getBytes();
		return Base64.getEncoder().encodeToString( credentialBytes );
	}
}
