/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.http;

import java.security.cert.X509Certificate;

import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * Non trust worthy {@link TrustManager}
 */
public class NoOpTrustManager implements X509TrustManager
{
	@Override
	public X509Certificate[] getAcceptedIssuers()
	{
		return new X509Certificate[ 0 ];
	}


	@Override
	public void checkClientTrusted( X509Certificate[] certs, String authType )
	{
		// No-op implementation
	}


	@Override
	public void checkServerTrusted( X509Certificate[] certs, String authType )
	{
		// No-op implementation
	}
}
