/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.http;

import java.io.IOException;
import java.io.InputStream;

import io.mambo.sdk.utils.StreamUtils;

public class HttpResponse
{
	private final HttpStatus code;
	private final HttpHeaders headers;
	private final String content;


	public HttpResponse(
		HttpStatus code,
		HttpHeaders headers,
		InputStream content ) throws IOException
	{
		this.code = code;
		this.headers = headers;
		this.content = StreamUtils.toString( content );
	}


	public HttpStatus code()
	{
		return code;
	}


	public HttpHeaders headers()
	{
		return headers;
	}


	public boolean hasContent()
	{
		return content != null;
	}


	public String content()
	{
		return content;
	}
}
