/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.http;

import java.util.AbstractMap.SimpleEntry;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.mambo.sdk.utils.Multimap;

/**
 * The headers of the HTTP request
 */
public class HttpHeaders
{
	private final Multimap<String, String> headers;


	public HttpHeaders() {
		headers = new Multimap<>();
	}


	private HttpHeaders( Multimap<String, String> headers ) {
		this.headers = headers;
	}


	public static HttpHeaders of( Map<String, List<String>> headers )
	{
		return new HttpHeaders( Multimap.of( headers ) );
	}


	public static HttpHeaders of( Multimap<String, String> headers )
	{
		return new HttpHeaders( headers );
	}


	public static HttpHeaders of( HttpHeaders headers )
	{
		return new HttpHeaders( Multimap.of( headers.headers ) );
	}


	public HttpHeaders addHeader( String key, String value )
	{
		headers.put( key, value );
		return this;
	}


	public HttpHeaders addHeader( SimpleEntry<String, String> header )
	{
		headers.put( header.getKey(), header.getValue() );
		return this;
	}


	public HttpHeaders addHeaderIf( boolean condition, String key, String value )
	{
		if( condition ) {
			headers.put( key, value );
		}
		return this;
	}


	public Set<Map.Entry<String, List<String>>> entrySet()
	{
		return headers.entrySet();
	}
}
