/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.exception.oauth;

import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.http.HttpStatus;
import lombok.ToString;

@ToString
public class OAuthException extends MamboApiException
{
	private static final long serialVersionUID = 1L;

	private final transient OAuthError oauthError;
	private final HttpStatus status;


	public OAuthException( OAuthError oauthError, HttpStatus status ) {
		super( oauthError.asMamboError(), status );
		this.oauthError = oauthError;
		this.status = status;
	}


	/**
	 * Returns the OAuth 2 error
	 */
	public String getError()
	{
		return oauthError.getError();
	}


	/**
	 * Returns the OAuth 2 error description
	 */
	public String getErrorDescription()
	{
		return oauthError.getErrorDescription();
	}


	/**
	 * Returns the OAuth 2 error URI (if any)
	 */
	public String getErrorUri()
	{
		return oauthError.getErrorUri();
	}


	/**
	 * The HTTP Status
	 * @return
	 */
	@Override
	public HttpStatus getHttpStatus() {
		return status;
	}
}
