/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.exception.oauth;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import io.mambo.sdk.exception.MamboError;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Provides details about the OAuth error returned by the Mambo API.
 */
@ToString
@EqualsAndHashCode
@JsonNaming( PropertyNamingStrategies.SnakeCaseStrategy.class )
public class OAuthError
{
	private String type;
	private String error;
	private String errorDescription;
	private String errorUri;


	/**
	 * The type of Exception being returned.
	 * This will always be OAuth2Exception
	 */
	public String getType() { return type; }
	public void setType( String type ) { this.type = type; }

	/**
	 * The OAuth 2 error e.g. invalid_token
	 */
	public String getError() { return error; }
	public void setError( String error ) { this.error = error; }

	/**
	 * The description of the error
	 */
	public String getErrorDescription() { return errorDescription; }
	public void setErrorDescription( String errorDescription ) { this.errorDescription = errorDescription; }

	/**
	 * An optional URI providing more information about the error
	 */
	public String getErrorUri() { return errorUri; }
	public void setErrorUri( String errorUri ) { this.errorUri = errorUri; }


	protected MamboError asMamboError()
	{
		MamboError mamboError = new MamboError();
		mamboError.setType( type );
		mamboError.setMessage( error );
		return mamboError;
	}
}