/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.exception;

/**
 * In case of a bad request, the Mambo API will return a validation error
 * for each invalid field in the request. Each invalid field will be mapped
 * against a ValidationError which will contain the name of the field and
 * an associated error message describing the problem in more detail.
 */
public class ParameterError
{
	private String name;
	private String message;

	/**
	 * Zero-arg constructor
	 */
	public ParameterError() {}

	/**
	 * Constructor
	 *
	 * @param name		The name of the field containing invalid data
	 * @param message	The message explaining why validation failed
	 */
	public ParameterError( String name, String message ) { setName( name ); setMessage( message ); }

	/**
	 * Get the name of the field containing invalid data
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }

	/**
	 * Get the message explaining why validation failed
	 * @return
	 */
	public String getMessage() { return message; }
	public void setMessage( String message ) { this.message = message; }


	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		builder.append( "ParameterError [name=" );
		builder.append( name );
		builder.append( ", message=" );
		builder.append( message );
		builder.append( "]" );
		return builder.toString();
	}
}