/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk;

import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Contains the SDKs version number
 */
public class Version
{
	private static final Logger LOG = LoggerFactory.getLogger( Version.class );

	private String apiVersion;


	public Version() {
		loadProperties();
	}


	private void loadProperties()
	{
		try {
			final Properties properties = new Properties();
			properties.load( this.getClass().getClassLoader().getResourceAsStream( "external.properties" ) );
			apiVersion = properties.getProperty( "version" );
		}
		catch( Exception ex ) {
			LOG.error( "Failed to load the version from the external.properties file", ex );
		}
	}


	public String getVersion()
	{
		return apiVersion;
	}
}
